*Title: How to increase maximum upload size?
*Slug: increase-maximal-upload-size

================================================================

In the self-hosted version of activeCollab, the **size of the file that you can upload is not limited** by the application. The limitations are enforced by your web server, and activeCollab only displays the current limit on forms that allow file upload as displayed here:

<{image name="file_upload_size.png"}>

To increase the maximum upload size, open phpthe .ini file and change the values of <{code}>upload_max_filesize<{/code}> and <{code}>post_max_size<{/code}> directives to the desired value. For example:

<{code}>upload_max_filesize = 64M
post_max_size = 64M<{/code}>

Save you php.ini file and restart your web server. If you do not have access to the php.ini, contact your system administrator or hosting provider to increase these values for you. You can point out that they need to be applied to the <{path}>/public<{/path}> folder. **Do not forget to restart your server after the changes in the php.ini have been made**. If you skip this step, the maximum upload size change will not be applied.

<{note title="Apache Note"}>Apache has a <{code}>LimitRequestBody<{/code}> configuration directive. It restricts the size of all POST data regardless of the web scripting language in use. You may need to update this value, too.<{/note}>